#ifndef __PLAYSTATE_H__
#define __PLAYSTATE_H__

#include "Utils.h"

#include "StateGame.h"
#include "BaseObject.h"

#include "StateManager.h"
#include "MenuState.h"
#include "EndState.h"
#include "PauseState.h"

#include "IObject.h"
#include "LObject.h"
#include "JObject.h"
#include "OObject.h"
#include "NObject.h"
#include "ZObject.h"
#include "TObject.h"

#define BOARD_COLLUMS 31
#define BOARD_ROWS 50

class PlayState : public StateGame
{
private:
	BaseObject *m_Piece;
	GRectangle m_Background;
	int **m_Board;
	int m_Score;
	int m_HeightBrick;

public:
	PlayState();
	~PlayState();
	PlayState(IDStateGame id);
	void Init();
	void Update();
	void Draw();
	void PauseGame();
	void ResumeGame();

	bool checkScored();
	void randomPiece();
	int checkHeight();
};

#endif